from bpy.props import BoolProperty
from bpy.types import PropertyGroup, Context
from ..updaters.props_update_particles import ui_update
from ....libs.functions.get_common_vars import get_common_vars


class ActiveMeshItemSwitchesProps(PropertyGroup):

    #--------------------------------------------------------------------------------------------------------------------
    """ Propiedades guardadas en el mesh_item.switchers.x ( Los iconos Para Global/Local modes ON/OFF, la cadenita ): """
    #--------------------------------------------------------------------------------------------------------------------

    switchers_names = "Global or Local Settings"
    switchers_descrt = "Change between Global or Local Settings" 

    @staticmethod
    def restore_global_ui_props(self, context:Context, call_from:str) -> None:
        
        """ 
            Cuando estabas en Local pero ahora se pulsa Global, se recupera la info del resto de Globales para 
            actualizar la ui del current item.
        """
        
        # Si se esta solicitando volver a Global:
        if getattr(self, call_from):

            fluid_groups = get_common_vars(context, get_fluid_groups=True)
            active_group = fluid_groups.active
            emitters_list = active_group.emitters
            active_emitter_item = emitters_list.active

            ui_update(context, active_emitter_item, without_self_ob=True)

    #-------------------------------------------------------------
    # Emission:
    #-------------------------------------------------------------
    global_mode_emission_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt, 
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_emission_sect")
    )
    global_mode_velocity_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_velocity_sect")
    )
    global_mode_viewport_display_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_viewport_display_sect")
    )
    #-------------------------------------------------------------
    # Physics:
    #-------------------------------------------------------------
    global_mode_integration_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_integration_sect")
    )
    global_mode_physics_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_physics_sect")
    )
    
    global_mode_advanced_b_sect: BoolProperty( # <- b de Behavior
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_advanced_b_sect")
    )
    global_mode_advanced_field_weights_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_advanced_field_weights_sect")
    )
    #-------------------------------------------------------------
    # Springs:
    #-------------------------------------------------------------
    global_mode_springs_sect: BoolProperty(
        name=switchers_names, 
        description=switchers_descrt,
        default=True, 
        update=lambda self, context: self.restore_global_ui_props(self, context, "global_mode_springs_sect")
    )